#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye: register (c8);
float4 fogData : register (c9);

struct VS_OUTPUT
{
   float4 Pos  : POSITION;
   float4 Diff : COLOR0;
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
   float2 Tex  : TEXCOORD0;
#if NUMTEX == 2
   float2 Tex1 : TEXCOORD1;
#endif   
};

#if NUMTEX == 2
  VS_OUTPUT vs11_noShadeT0T1 (float4 inPos : POSITION, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inTex1 : TEXCOORD1)
#elif NUMTEX == 1
  VS_OUTPUT vs11_noShadeT0 (float4 inPos : POSITION, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
#else  
  VS_OUTPUT vs11_noShade (float4 inPos : POSITION, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
#endif  
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);

#ifdef USEFOG
  // compute fog
  float3 eyeVec = mul (worldMatrix, inPos) + worldEye;
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif
  
  // Propagate color and texture coordinates:
  Out.Diff = inColor;
  Out.Tex = inTex;
#if NUMTEX == 2
  Out.Tex1 = inTex1;
#endif   

  return (Out);
}








